<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Rate extends Model 
{

    protected $table = 'rates';
    public $timestamps = true;
    protected $fillable = array('rate', 'family_id', 'driver_id', 'user_id');

    public function user()
    {
        return $this->belongsTo('App\User', 'user_id');
    }

    public function family()
    {
        return $this->belongsTo('App\User', 'family_id');
    }

    public function driver()
    {
        return $this->belongsTo('App\User', 'driver_id');
    }

}